//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace CLRUnleashed
{
	public class PointEventArgs : EventArgs
	{
		private Point point;
		public PointEventArgs(int x, int y)
		{
			point = new Point(x, y);
		}
		public Point Point
		{
			get
			{
				return point;
			}
			set
			{
				point = value;
			}
		}
	}

	public struct Point
	{
		// Zdarzenie uywane przez klienta w celu powiadomienia
		// o zmianie elementw listy:
		public event EventHandler Changed;
		private int _x;
		private int _y;
		// Wywoanie zdarzenia Changed event; uywane przy kadej zmianie punktu:
		private void OnChanged(PointEventArgs e) 
		{
			if (Changed != null)
				Changed(this, e);
		}
		public Point(int x, int y)
		{
			_x = x;
			_y = y;
			Changed = null;
		}
		public int X
		{
			get
			{
				return _x;
			}
			set
			{
				_x = value;
				PointEventArgs e = new PointEventArgs(_x, _y);
				OnChanged(e);
			}
		}
		public int Y
		{
			get
			{
				return _y;
			}
			set
			{
				_y = value;
				PointEventArgs e = new PointEventArgs(_x, _y);
				OnChanged(e);
			}
		}
		public Point Coordinate
		{
			get
			{
				return this;
			}
			set
			{
				_x = value._x;
				_y = value._y;
				PointEventArgs e = new PointEventArgs(_x, _y);
				OnChanged(e);
			}
		}
	}

	/// <summary>
	/// Podsumowanie dla ValuePoint.
	/// </summary>
	class ValuePoint
	{
		private static void Changed(object sender, EventArgs e) 
		{
			PointEventArgs pe = (PointEventArgs)e;
			Console.WriteLine("Punkt zmieni si. ({0}, {1})", pe.Point.X, pe.Point.Y);
		}
		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			Point p = new Point();
			Console.WriteLine("Punkt {0}", p.GetType().BaseType);
			p.Changed += new EventHandler(Changed);
			p.Coordinate = new Point(1, 2);
		}
	}
}
